#include "Koopa.h"
#include "Level.h"

Koopa::Koopa()
{
	walk.addFrame(sf::IntRect(96, 8, 16, 24));		//
	walk.addFrame(sf::IntRect(112, 8, 16, 24));		//		Set anim frames from sprite sheet
	walk.setFrameSpeed(1.f / 4.f);		//		Set frame speed for walking

	shell.addFrame(sf::IntRect(160, 17, 16, 14));		// Set anim frame from sprite sheet

	currentAnimation = &walk;
	setTextureRect(currentAnimation->getCurrentFrame());

	setCollisionBox(sf::FloatRect(0, 28, 50, 47));

	setSize(sf::Vector2f(50, 75));
	setVelocity(-75, 0);	//Set the Koopa's velocity to -75 so it initally moves left toward Mario

	spriteType = SpriteType::KoopaSprite;	//Set the spriteType to a KoopaSprite
}


Koopa::~Koopa()
{
}

void Koopa::handleMarioCollision(Mario* mario)
{
	if (!getInvincible())	//If the Koopa isn't invincible
	{
		switch (state)
		{
			case KoopaState::Walking:	//If it's walking
				Level::audioManager->playSoundByName("Squish");

				if (!mario->getAirbourne())
				{ 
					mario->powerDown();
					break;
				}
				
				else
				{
					mario->bounce();
					mario->addScore(200);	//Add 200 score for sending the Koopa into its shell
					setPosition(getPosition().x, getPosition().y + 35);	//Set its position down 35 pixels to account for the size decrease
				}
				//Case fallthrough here

			case KoopaState::MovingShell:	//If the Koopa is moving in its shell
				if (!mario->getAirbourne())
				{
					mario->powerDown();
				}

				else
				{
					mario->bounce();
					state = KoopaState::Shell;	//Set the state of the Koopa to be in its shell
					currentAnimation = &shell;
					setSize(sf::Vector2f(50, 40));	//Decrease the size of the Koopa
					velocity = sf::Vector2f(0, 0);	//Stop the Koopa's movement
					setCollisionBox(sf::FloatRect(0, 0, 50, 40));	//Update the collision box
				}
				break;

			case KoopaState::Shell:	//If the Koopa is in its shell
				Level::audioManager->playSoundByName("Kick");
				mario->setInvincible(true, 0.2);
				state = KoopaState::MovingShell;	//Set the state to be moving in its shell
				velocity = sf::Vector2f(350, 0);	//Set the Koopa's velocity to move toward the right
				setPosition(getPosition().x + 5, getPosition().y);	//We move the Koopa 8 pixels forward so Mario can't immediately collide again and die

				if (mario->getPosition().x >= getPosition().x + ((getSize().x) / 2))	//If Mario's has touched the right side of the Koopa
				{
					velocity.x = -velocity.x;	//Invert the Koopa's velocity to move toward the left
				}

				break;
		}
	}
}

Koopa::KoopaState Koopa::getKoopaState()
{
	return state;	//Return the state of the Koopa
}